function getcdf, filename, varname, misdat=misdat, type=type, time=time, $
                 starty=starty, startm=startm, startd=startd, $
                 starth=starth, starti=starti, unit_time=unit_time, $
                 composite=composite, albis=albis, dole=dole, lema=lema, $
                 xmin=xmin, ymin=ymin, xmax=xmax, ymax=ymax,$
                 nx=nx, ny=ny, dx=dx, dy=dy,$
                 nodata=nodata

sn  = '  getcdf: '
if not keyword_set(nodata) then nodata = 0
if not keyword_set(type) then type = 'SRN'


print, sn,'try to read variable ',varname, ' in file ',filename


; open required netcdf file
;------------------------------------------------------------------
cdfid = ncdf_open(filename)

; get variable and misdat value
;------------------------------------------------------------------
varid = ncdf_varid(cdfid, varname)



if (varid eq -1) then begin
    print,sn,' WARNING: variable ',varname,' is not in netcdf file ,', filename
    ncdf_close, cdfid
    return, -1
endif

ncdf_attget,cdfid, varid, 'missing_data', misdat
ncdf_attget,cdfid, varid, 'xmin',xmin
ncdf_attget,cdfid, varid, 'xmax',xmax
ncdf_attget,cdfid, varid, 'xstag',xstag
ncdf_attget,cdfid, varid, 'ymin',ymin
ncdf_attget,cdfid, varid, 'ymax',ymax
ncdf_attget,cdfid, varid, 'ystag',ystag
ncdf_attget,cdfid, varid, 'zmin',zmin
ncdf_attget,cdfid, varid, 'zmax',zmax
ncdf_attget,cdfid, varid, 'zstag',zstag


; get variable and its dimensions
;--------------------------------
if (not nodata) then ncdf_varget,cdfid, varid, var
ncdf_attget,cdfid,'nx',nx,/GLOBAL
ncdf_attget,cdfid,'ny',ny,/GLOBAL
ncdf_attget,cdfid,'dellon' ,dx,/GLOBAL
ncdf_attget,cdfid,'dellat' ,dy,/GLOBAL



; get time value (caveat: dimension 'time' has same name as var 'time')
;----------------------------------------------------------------------
varid = ncdf_varid(cdfid, 'time')      & ncdf_varget, cdfid, varid, time
varid = ncdf_varid(cdfid, 'starty')    & ncdf_varget, cdfid, varid, starty
varid = ncdf_varid(cdfid, 'startm')    & ncdf_varget, cdfid, varid, startm
varid = ncdf_varid(cdfid, 'startd')    & ncdf_varget, cdfid, varid, startd
varid = ncdf_varid(cdfid, 'starth')    & ncdf_varget, cdfid, varid, starth
starti = 0L ; default value, since not in LM netcdf file

; get radar information on availability
;--------------------------------------
if strupcase(type) eq 'SRN' then begin

    varid = ncdf_varid(cdfid, 'starti')    & ncdf_varget, cdfid, varid, starti
    varid = ncdf_varid(cdfid, 'composite') & ncdf_varget, cdfid, varid, composite
    varid = ncdf_varid(cdfid, 'albis')     & ncdf_varget, cdfid, varid, albis
    varid = ncdf_varid(cdfid, 'dole')      & ncdf_varget, cdfid, varid, dole
    varid = ncdf_varid(cdfid, 'lema')      & ncdf_varget, cdfid, varid, lema
    ncdf_attget, cdfid, /global, 'units', unit_time
    unit_time = string(unit_time)
endif
; close netcdf file
;------------------
ncdf_close, cdfid

if (nodata) then $
  return, 1 $
else $
  return, var

end
