pro getswissdata,obs,fcst,hour=hour, show=show

;Get Swiss aLMo and radar precipitation data provided by Daniel Leuenberger
;Output:  obs        Array of rain observations (mm/hr) [480,350]
;         fcst       Array of rain forecast (mm/hr) [480,350]
;Keywds:  hour       Hour to get (range from 1-24)
;                      To get the accumulation over more than one hour then enter
;                      hour as a 2-integer array (ex: first six hours is hour=[1,6])
;         show       Plot the rain fields
;
;See email from D. Leuenberger on 30-8-2006 for information on raw data.

if n_elements(hour) eq 0 then hour=1

;Get radar data from netCDF file (starts with hour 1, is not cumulated)
file='data\swiss\200305080000_SRN.cdf'
allobs  = getcdf(file,'PLC', time=radartime)

;Get forecast data from netCDF file (starts with hour 0, is cumulated)
file='data\swiss\200305080000_MFC.cdf'
allfcst = getcdf(file,'RAIN_GSP', type='LM', time=lmtime, $
                 misdat=misdat_ls,starty=starty_lm,startm=startm_lm, $
                 startd=startd_lm,starth=starth_lm,starti=starti_lm)

;Convert forecasts from cumulated values to hourly values
for it=n_elements(lmtime)-1,1,-1 do $
  allfcst[*,*,0,it] = allfcst[*,*,0,it] - allfcst[*,*,0,it-1]

;Get the data for the chosen hour or range of hours
obs =allobs[*,*,0,hour[0]-1]
fcst=allfcst[*,*,0,hour[0]]
if n_elements(hour) eq 2 then begin
  for it=hour[0]+1,hour[1] do begin
    obs  = obs  + allobs[*,*,0,it-1]
    fcst = fcst + allfcst[*,*,0,it]
    endfor
  endif


if n_elements(show) eq 0 then show=0
if (show) then begin

  ;Use Z-buffer, it's much quicker than drawing directly to the window...
  terminal_type=!d.name
  set_plot,'Z'
  device, set_resolution=[540,232]
  device, set_colors=256
  device, z_buffering=0

  set_qpf_colors
  tvlct,r,g,b,/get

  contour,obs, $
    level=[0.,.1,.16,.25,.4,.63,1,1.6,2.5,4,6.3,10,16,25,40,63,100,160], $
    /cell_fill,c_color=[0,indgen(18)], $
    xrange=[34,303],yrange=[70,301],/xstyle,/ystyle, $
    xticks=1,yticks=1,position=[0,0,.5,1]
  contour,fcst,/noerase, $
    level=[0.,.1,.16,.25,.4,.63,1,1.6,2.5,4,6.3,10,16,25,40,63,100,160], $
    /cell_fill,c_color=[0,indgen(18)], $
    xrange=[34,303],yrange=[70,301],/xstyle,/ystyle, $
    xticks=1,yticks=1,position=[.5,0,1,1],ytickname=[' ',' ']

  image=tvrd()
  device,/close
  set_plot,terminal_type
  window,xsize=540,ysize=232
  tv,image
  endif


done:
end
