/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class StreamUtil {
    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                Log.log.warning("Error closing input stream", "stream", inputStream, "cause", iOException);
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
                return;
            }
            catch (IOException iOException) {
                Log.log.warning("Error closing output stream", "stream", outputStream, "cause", iOException);
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
                return;
            }
            catch (IOException iOException) {
                Log.log.warning("Error closing reader", "reader", reader, "cause", iOException);
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {
                Log.log.warning("Error closing writer", "writer", writer, "cause", iOException);
            }
        }
    }

    public static <T extends OutputStream> T copy(InputStream inputStream, T t2) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) > 0) {
            t2.write(byArray, 0, n2);
        }
        return t2;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        return StreamUtil.copy(inputStream, new ByteArrayOutputStream()).toByteArray();
    }
}

