/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.classpath;

import com.threerings.getdown.classpath.ClassPath;
import com.threerings.getdown.classpath.cache.GarbageCollector;
import com.threerings.getdown.classpath.cache.ResourceCache;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Resource;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;

public class ClassPaths {
    static final String CACHE_DIR = ".cache";

    public static ClassPath buildClassPath(Application application) throws IOException {
        if (application.useCodeCache()) {
            return ClassPaths.buildCachedClassPath(application);
        }
        return ClassPaths.buildDefaultClassPath(application);
    }

    public static ClassPath buildDefaultClassPath(Application object) {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (Resource resource : ((Application)object).getActiveCodeResources()) {
            linkedHashSet.add(resource.getFinalTarget());
        }
        return new ClassPath(linkedHashSet);
    }

    public static ClassPath buildCachedClassPath(Application application) throws IOException {
        File file = new File(application.getAppDir(), CACHE_DIR);
        if (application.getCodeCacheRetentionDays() <= 0) {
            ClassPaths.runGarbageCollection(application, file);
        }
        ResourceCache resourceCache = new ResourceCache(file);
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        for (Comparable<Resource> comparable : application.getActiveCodeResources()) {
            comparable = resourceCache.cacheFile(comparable.getFinalTarget(), application.getDigest((Resource)comparable));
            linkedHashSet.add((File)comparable);
        }
        if (application.getCodeCacheRetentionDays() > 0) {
            ClassPaths.runGarbageCollection(application, file);
        }
        return new ClassPath(linkedHashSet);
    }

    private static void runGarbageCollection(Application application, File file) {
        long l2 = TimeUnit.DAYS.toMillis(application.getCodeCacheRetentionDays());
        GarbageCollector.collect(file, l2);
    }
}

