/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.classpath.cache;

import com.threerings.getdown.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class ResourceCache {
    private final File _cacheDir;
    static final String LAST_ACCESSED_FILE_SUFFIX = ".lastAccessed";

    public ResourceCache(File file) throws IOException {
        this._cacheDir = file;
        this.createDirectoryIfNecessary(file);
    }

    private void createDirectoryIfNecessary(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("unable to create directory: " + file.getAbsolutePath());
        }
    }

    public File cacheFile(File file, String object) throws IOException {
        File file2 = new File(this._cacheDir, ((String)object).substring(0, 2));
        this.createDirectoryIfNecessary(file2);
        object = new File(file2, (String)object + this.getFileSuffix(file));
        file2 = new File(file2, ((File)object).getName() + LAST_ACCESSED_FILE_SUFFIX);
        if (!((File)object).exists()) {
            this.createNewFile((File)object);
            FileUtil.copy(file, (File)object);
        }
        if (file2.exists()) {
            file2.setLastModified(System.currentTimeMillis());
        } else {
            this.createNewFile(file2);
        }
        return object;
    }

    private void createNewFile(File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("unable to create new file: " + file.getAbsolutePath());
        }
    }

    private String getFileSuffix(File object) {
        int n2 = ((String)(object = ((File)object).getName())).lastIndexOf(".");
        if (n2 >= 0) {
            return ((String)object).substring(n2);
        }
        return "";
    }
}

