/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.data.g;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Resource
implements Comparable<Resource> {
    public static final EnumSet<Attr> NORMAL = EnumSet.noneOf(Attr.class);
    public static final EnumSet<Attr> UNPACK = EnumSet.of(Attr.UNPACK);
    public static final EnumSet<Attr> EXEC = EnumSet.of(Attr.EXEC);
    protected String _path;
    protected URL _remote;
    protected File _local;
    protected File _localNew;
    protected File _marker;
    protected File _unpacked;
    protected EnumSet<Attr> _attrs;
    protected boolean _isJar;
    protected boolean _isPacked200Jar;
    protected static final Comparator<JarEntry> ENTRY_COMP = new g();
    protected static final int DIGEST_BUFFER_SIZE = 5125;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String computeDigest(int n2, File file, MessageDigest messageDigest, ProgressObserver progressObserver) throws IOException {
        messageDigest.reset();
        byte[] byArray = new byte[5125];
        int n3 = Resource.isJar(file.getPath());
        boolean bl = Resource.isPacked200Jar(file.getPath());
        if (n3 != 0 || bl) {
            File file2 = null;
            JarFile jarFile = null;
            try {
                if (bl) {
                    file2 = new File(file.getPath() + ".tmp");
                    FileUtil.unpackPacked200Jar(file, file2);
                    jarFile = new JarFile(file2);
                } else {
                    jarFile = new JarFile(file);
                }
                ArrayList<JarEntry> arrayList = Collections.list(jarFile.entries());
                Collections.sort(arrayList, ENTRY_COMP);
                for (JarEntry jarEntry : arrayList) {
                    block28: {
                        if (n2 < 2 && jarEntry.getName().startsWith("META-INF")) {
                            Resource.updateProgress(progressObserver, 0L, arrayList.size());
                            continue;
                        }
                        InputStream inputStream = jarFile.getInputStream(jarEntry);
                        Throwable throwable = null;
                        try {
                            while ((n3 = inputStream.read(byArray)) != -1) {
                                messageDigest.update(byArray, 0, n3);
                            }
                            if (inputStream == null) break block28;
                        }
                        catch (Throwable throwable2) {
                            try {
                                Throwable throwable3 = throwable2;
                                Throwable throwable4 = throwable2;
                                throw throwable3;
                            }
                            catch (Throwable throwable5) {
                                if (inputStream == null) throw throwable5;
                                if (throwable == null) {
                                    inputStream.close();
                                    throw throwable5;
                                }
                                try {
                                    inputStream.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                        inputStream.close();
                    }
                    Resource.updateProgress(progressObserver, 0L, arrayList.size());
                }
            }
            catch (Throwable throwable) {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        Log.log.warning("Error closing jar", "path", file, "jar", jarFile, "error", iOException);
                    }
                }
                if (file2 == null) throw throwable;
                FileUtil.deleteHarder(file2);
                throw throwable;
            }
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                Log.log.warning("Error closing jar", "path", file, "jar", jarFile, "error", iOException);
            }
            if (file2 == null) return StringUtil.hexlate(messageDigest.digest());
            FileUtil.deleteHarder(file2);
            return StringUtil.hexlate(messageDigest.digest());
        }
        long l2 = file.length();
        long l3 = 0L;
        FileInputStream fileInputStream = new FileInputStream(file);
        Throwable throwable = null;
        try {
            while ((n3 = fileInputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n3);
                Resource.updateProgress(progressObserver, l3 += (long)n3, l2);
            }
        }
        catch (Throwable throwable7) {
            try {
                Throwable throwable8 = throwable7;
                Throwable throwable9 = throwable7;
                throw throwable8;
            }
            catch (Throwable throwable10) {
                if (throwable == null) {
                    fileInputStream.close();
                    throw throwable10;
                }
                try {
                    fileInputStream.close();
                    throw throwable10;
                }
                catch (Throwable throwable11) {
                    throwable.addSuppressed(throwable11);
                    throw throwable10;
                }
            }
        }
        fileInputStream.close();
        return StringUtil.hexlate(messageDigest.digest());
    }

    public Resource(String string, URL object, File file, EnumSet<Attr> enumSet) {
        this._path = string;
        this._remote = object;
        this._local = file;
        this._localNew = new File(file.toString() + "_new");
        string = this._local.getPath();
        this._marker = new File(string + "v");
        this._attrs = enumSet;
        this._isJar = Resource.isJar(string);
        this._isPacked200Jar = Resource.isPacked200Jar(string);
        boolean bl = enumSet.contains((Object)Attr.UNPACK);
        if (bl && this._isJar) {
            this._unpacked = this._local.getParentFile();
            return;
        }
        if (bl && this._isPacked200Jar) {
            String string2 = ".jar";
            object = this._local.getName();
            string2 = ((String)object).substring(0, ((String)object).lastIndexOf(string2) + string2.length());
            this._unpacked = new File(this._local.getParent(), string2);
        }
    }

    public String getPath() {
        return this._path;
    }

    public File getLocal() {
        return this._local;
    }

    public File getLocalNew() {
        return this._localNew;
    }

    public File getUnpacked() {
        return this._unpacked;
    }

    public File getFinalTarget() {
        if (this.shouldUnpack()) {
            return this.getUnpacked();
        }
        return this.getLocal();
    }

    public URL getRemote() {
        return this._remote;
    }

    public boolean shouldUnpack() {
        return this._attrs.contains((Object)Attr.UNPACK) && !SysProps.noUnpack();
    }

    public String computeDigest(int n2, MessageDigest messageDigest, ProgressObserver progressObserver) throws IOException {
        File file = !this._local.toString().toLowerCase(Locale.ROOT).endsWith("getdown.txt") && this._localNew.exists() ? this._localNew : this._local;
        return Resource.computeDigest(n2, file, messageDigest, progressObserver);
    }

    public boolean isMarkedValid() {
        if (!this._local.exists()) {
            this.clearMarker();
            return false;
        }
        return this._marker.exists();
    }

    public void markAsValid() throws IOException {
        this._marker.createNewFile();
    }

    public void clearMarker() {
        if (this._marker.exists() && !FileUtil.deleteHarder(this._marker)) {
            Log.log.warning("Failed to erase marker file '" + this._marker + "'.", new Object[0]);
        }
    }

    public void install() throws IOException {
        File file = this.getLocalNew();
        File file2 = this.getLocal();
        Log.log.info("- " + file, new Object[0]);
        if (!FileUtil.renameTo(file, file2)) {
            throw new IOException("Failed to rename " + file + " to " + file2);
        }
        this.applyAttrs();
        this.markAsValid();
    }

    public void unpack() throws IOException {
        block10: {
            block9: {
                if (!this._isJar && !this._isPacked200Jar) {
                    throw new IOException("Requested to unpack non-jar file '" + this._local + "'.");
                }
                if (!this._isJar) break block9;
                JarFile jarFile = new JarFile(this._local);
                Throwable throwable = null;
                try {
                    FileUtil.unpackJar(jarFile, this._unpacked);
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            jarFile.close();
                        }
                        throw throwable4;
                    }
                }
                jarFile.close();
                break block10;
            }
            FileUtil.unpackPacked200Jar(this._local, this._unpacked);
        }
    }

    public void applyAttrs() throws IOException {
        if (this.shouldUnpack()) {
            this.unpack();
        }
        if (this._attrs.contains((Object)Attr.EXEC)) {
            FileUtil.makeExecutable(this._local);
        }
    }

    public void erase() {
        this.clearMarker();
        if (this._local.exists() && !FileUtil.deleteHarder(this._local)) {
            Log.log.warning("Failed to erase resource '" + this._local + "'.", new Object[0]);
        }
    }

    @Override
    public int compareTo(Resource resource) {
        return this._path.compareTo(resource._path);
    }

    public boolean equals(Object object) {
        if (object instanceof Resource) {
            return this._path.equals(((Resource)object)._path);
        }
        return false;
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public String toString() {
        return this._path;
    }

    protected static void updateProgress(ProgressObserver progressObserver, long l2, long l3) {
        if (progressObserver != null) {
            progressObserver.progress((int)(100L * l2 / l3));
        }
    }

    protected static boolean isJar(String string) {
        return string.endsWith(".jar") || string.endsWith(".jar_new");
    }

    protected static boolean isPacked200Jar(String string) {
        return string.endsWith(".jar.pack") || string.endsWith(".jar.pack_new") || string.endsWith(".jar.pack.gz") || string.endsWith(".jar.pack.gz_new");
    }

    public static enum Attr {
        UNPACK,
        EXEC;

    }
}

