/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.net;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.net.Downloader;
import com.threerings.getdown.util.ConnectionUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public class HTTPDownloader
extends Downloader {
    @Override
    protected long checkSize(Resource resource) throws IOException {
        URLConnection uRLConnection = ConnectionUtil.open(resource.getRemote(), 0, 0);
        try {
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod("HEAD");
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() != 200) {
                    throw new IOException("Unable to check up-to-date for " + resource.getRemote() + ": " + httpURLConnection.getResponseCode());
                }
            }
            long l2 = uRLConnection.getContentLength();
            return l2;
        }
        finally {
            uRLConnection.getInputStream().close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void download(Resource resource) throws IOException {
        HttpURLConnection httpURLConnection;
        Object object = ConnectionUtil.open(resource.getRemote(), 0, 0);
        ((URLConnection)object).connect();
        if (object instanceof HttpURLConnection && (httpURLConnection = (HttpURLConnection)object).getResponseCode() != 200) {
            throw new IOException("Unable to download resource " + resource.getRemote() + ": " + httpURLConnection.getResponseCode());
        }
        long l2 = ((URLConnection)object).getContentLength();
        Log.log.info("Downloading resource", "url", resource.getRemote(), "size", l2);
        long l3 = 0L;
        byte[] byArray = new byte[16384];
        object = ((URLConnection)object).getInputStream();
        Throwable throwable = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(resource.getLocalNew());
            Throwable throwable2 = null;
            try {
                int n2;
                while ((n2 = ((InputStream)object).read(byArray)) != -1 && this._state != Downloader.State.ABORTED) {
                    fileOutputStream.write(byArray, 0, n2);
                    this.reportProgress(resource, l3 += (long)n2, l2);
                }
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable3;
                    throwable2 = throwable3;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable2 != null) {
                        try {
                            fileOutputStream.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        throw throwable5;
                    } else {
                        fileOutputStream.close();
                    }
                    throw throwable5;
                }
            }
            fileOutputStream.close();
            if (object == null) return;
        }
        catch (Throwable throwable7) {
            try {
                Throwable throwable8 = throwable7;
                throwable = throwable7;
                throw throwable8;
            }
            catch (Throwable throwable9) {
                if (object == null) throw throwable9;
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                        throw throwable9;
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                    throw throwable9;
                } else {
                    ((InputStream)object).close();
                }
                throw throwable9;
            }
        }
        ((InputStream)object).close();
        return;
    }
}

