/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.tools.JarDiff;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.StreamUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class Differ {
    public void createDiff(File file, File object, boolean bl) throws IOException {
        ArrayList<Resource> arrayList = file.getName();
        String string = ((File)object).getName();
        try {
            if (Long.parseLong((String)((Object)arrayList)) <= Long.parseLong(string)) {
                object = "New version (" + (String)((Object)arrayList) + ") must be greater than old version (" + string + ").";
                throw new IOException((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Non-numeric versions? [nvers=" + (String)((Object)arrayList) + ", overs=" + string + "].");
        }
        object = new Application(new EnvConfig((File)object));
        ((Application)object).init(false);
        arrayList = new ArrayList<Resource>();
        arrayList.addAll(((Application)object).getCodeResources());
        arrayList.addAll(((Application)object).getResources());
        Application application = new Application(new EnvConfig(file));
        application.init(false);
        Object object2 = new ArrayList<Resource>();
        ((ArrayList)object2).addAll(application.getCodeResources());
        ((ArrayList)object2).addAll(application.getResources());
        File object32 = new File(file, "patch" + string + ".dat");
        this.createPatch(object32, arrayList, (ArrayList<Resource>)object2, bl);
        for (Application.AuxGroup auxGroup : application.getAuxGroups()) {
            arrayList = new ArrayList<Resource>();
            object2 = ((Application)object).getAuxGroup(auxGroup.name);
            if (object2 != null) {
                arrayList.addAll(((Application.AuxGroup)object2).codes);
                arrayList.addAll(((Application.AuxGroup)object2).rsrcs);
            }
            object2 = new ArrayList<Resource>();
            ((ArrayList)object2).addAll(auxGroup.codes);
            ((ArrayList)object2).addAll(auxGroup.rsrcs);
            File file2 = new File(file, "patch-" + auxGroup.name + string + ".dat");
            this.createPatch(file2, arrayList, (ArrayList<Resource>)object2, bl);
        }
    }

    protected void createPatch(File file, ArrayList<Resource> arrayList, ArrayList<Resource> iterator, boolean bl) throws IOException {
        MessageDigest messageDigest = Digest.getMessageDigest(2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                Throwable throwable2 = null;
                try {
                    JarOutputStream jarOutputStream = new JarOutputStream(bufferedOutputStream);
                    Throwable throwable3 = null;
                    try {
                        iterator = ((ArrayList)((Object)iterator)).iterator();
                        while (iterator.hasNext()) {
                            Resource resource = (Resource)iterator.next();
                            int n2 = arrayList.indexOf(resource);
                            Comparable<Resource> comparable = n2 == -1 ? null : arrayList.remove(n2);
                            if (comparable != null) {
                                String string;
                                Object object = comparable.computeDigest(2, messageDigest, null);
                                if (((String)object).equals(string = resource.computeDigest(2, messageDigest, null))) {
                                    if (!bl) continue;
                                    System.out.println("Unchanged: " + resource.getPath());
                                    continue;
                                }
                                if (resource.getPath().endsWith(".jar")) {
                                    if (bl) {
                                        System.out.println("JarDiff: " + resource.getPath());
                                    }
                                    comparable = this.rebuildJar(comparable.getLocal());
                                    object = this.rebuildJar(resource.getLocal());
                                    jarOutputStream.putNextEntry(new ZipEntry(resource.getPath() + ".patch"));
                                    this.jarDiff((File)comparable, (File)object, jarOutputStream);
                                    FileUtil.deleteHarder((File)comparable);
                                    FileUtil.deleteHarder((File)object);
                                    continue;
                                }
                            }
                            if (bl) {
                                System.out.println("Addition: " + resource.getPath());
                            }
                            jarOutputStream.putNextEntry(new ZipEntry(resource.getPath() + ".create"));
                            Differ.pipe(resource.getLocal(), jarOutputStream);
                        }
                        for (Resource resource : arrayList) {
                            if (bl) {
                                System.out.println("Removal: " + resource.getPath());
                            }
                            jarOutputStream.putNextEntry(new ZipEntry(resource.getPath() + ".delete"));
                        }
                        System.out.println("Created patch file: " + file);
                    }
                    catch (Throwable throwable4) {
                        try {
                            iterator = throwable4;
                            throwable3 = throwable4;
                            throw iterator;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 != null) {
                                try {
                                    jarOutputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable3.addSuppressed(throwable6);
                                }
                            } else {
                                jarOutputStream.close();
                            }
                            throw throwable5;
                        }
                    }
                    jarOutputStream.close();
                }
                catch (Throwable throwable7) {
                    try {
                        Throwable throwable8 = throwable7;
                        throwable2 = throwable7;
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        if (throwable2 != null) {
                            try {
                                bufferedOutputStream.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                        } else {
                            bufferedOutputStream.close();
                        }
                        throw throwable9;
                    }
                }
                bufferedOutputStream.close();
            }
            catch (Throwable throwable11) {
                try {
                    Throwable throwable12 = throwable11;
                    throwable = throwable11;
                    throw throwable12;
                }
                catch (Throwable throwable13) {
                    if (throwable != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Throwable throwable14) {
                            throwable.addSuppressed(throwable14);
                        }
                    } else {
                        fileOutputStream.close();
                    }
                    throw throwable13;
                }
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            FileUtil.deleteHarder(file);
            throw iOException;
        }
    }

    /*
     * Exception decompiling
     */
    protected File rebuildJar(File var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void jarDiff(File file, File file2, JarOutputStream jarOutputStream) throws IOException {
        JarDiff.createPatch(file.getPath(), file2.getPath(), jarOutputStream, false);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage: Differ [-verbose] new_vers_dir old_vers_dir");
            System.exit(255);
        }
        Differ differ = new Differ();
        boolean bl = false;
        int n2 = 0;
        if (stringArray[0].equals("-verbose")) {
            bl = true;
            ++n2;
        }
        try {
            differ.createDiff(new File(stringArray[n2++]), new File(stringArray[n2]), bl);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException.getMessage());
            System.exit(255);
            return;
        }
    }

    protected static void pipe(File object, JarOutputStream object2) throws IOException {
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            StreamUtil.copy((InputStream)object, object2);
        }
        catch (Throwable throwable2) {
            try {
                object2 = throwable2;
                throwable = throwable2;
                throw object2;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    ((FileInputStream)object).close();
                }
                throw throwable3;
            }
        }
        ((FileInputStream)object).close();
        return;
    }
}

