/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.StreamUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static boolean renameTo(File file, File file2) {
        if (file.renameTo(file2)) {
            return true;
        }
        if (file2.exists()) {
            File file3 = new File(file2.getPath() + "_old");
            if (file3.exists() && !FileUtil.deleteHarder(file3)) {
                Log.log.warning("Failed to delete old intermediate file " + file3 + ".", new Object[0]);
            }
            if (file2.renameTo(file3) && file.renameTo(file2)) {
                if (!FileUtil.deleteHarder(file3)) {
                    Log.log.warning("Failed to delete intermediate file " + file3 + ".", new Object[0]);
                }
                return true;
            }
        }
        try {
            FileUtil.copy(file, file2);
        }
        catch (IOException iOException) {
            Log.log.warning("Failed to copy " + file + " to " + file2 + ": " + iOException, new Object[0]);
            return false;
        }
        if (!FileUtil.deleteHarder(file)) {
            Log.log.warning("Failed to delete " + file + " after brute force copy to " + file2 + ".", new Object[0]);
        }
        return true;
    }

    public static boolean deleteHarder(File file) {
        boolean bl = file.delete() || file.delete();
        if (!bl) {
            file.deleteOnExit();
        }
        return bl;
    }

    public static List<String> readLines(Reader reader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        reader = new BufferedReader(reader);
        Throwable throwable = null;
        try {
            String string;
            while ((string = ((BufferedReader)reader).readLine()) != null) {
                arrayList.add(string);
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        ((BufferedReader)reader).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ((BufferedReader)reader).close();
                }
                throw throwable4;
            }
        }
        ((BufferedReader)reader).close();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unpackJar(JarFile jarFile, File serializable) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            File file = new File((File)serializable, ((ZipEntry)object).getName());
            if (((ZipEntry)object).isDirectory()) {
                if (file.exists() || file.mkdir()) continue;
                Log.log.warning("Failed to create jar entry path", "jar", jarFile, "entry", object);
                continue;
            }
            Object object2 = new File(file.getParent());
            if (!((File)object2).exists() && !((File)object2).mkdirs()) {
                Log.log.warning("Failed to create jar entry parent", "jar", jarFile, "parent", object2);
                continue;
            }
            try {
                block19: {
                    object2 = new BufferedOutputStream(new FileOutputStream(file));
                    Throwable throwable = null;
                    try {
                        object = jarFile.getInputStream((ZipEntry)object);
                        Throwable throwable2 = null;
                        try {
                            StreamUtil.copy((InputStream)object, object2);
                            if (object == null) break block19;
                        }
                        catch (Throwable throwable3) {
                            try {
                                Throwable throwable4 = throwable3;
                                throwable2 = throwable3;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (object == null) throw throwable5;
                                if (throwable2 == null) {
                                    ((InputStream)object).close();
                                    throw throwable5;
                                }
                                try {
                                    ((InputStream)object).close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable7) {
                        try {
                            object = throwable7;
                            throwable = throwable7;
                            throw object;
                        }
                        catch (Throwable throwable8) {
                            if (throwable == null) {
                                ((FilterOutputStream)object2).close();
                                throw throwable8;
                            }
                            try {
                                ((FilterOutputStream)object2).close();
                                throw throwable8;
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                                throw throwable8;
                            }
                        }
                    }
                }
                ((FilterOutputStream)object2).close();
            }
            catch (Exception exception) {
                throw new IOException(Log.format("Failure unpacking", "jar", jarFile, "entry", file), exception);
            }
        }
    }

    public static void unpackPacked200Jar(File serializable, File object) throws IOException {
        FileInputStream fileInputStream = new FileInputStream((File)serializable);
        Throwable throwable = null;
        try {
            object = new JarOutputStream(new FileOutputStream((File)object));
            Throwable throwable2 = null;
            try {
                boolean bl = ((File)serializable).getName().endsWith(".gz") || ((File)serializable).getName().endsWith(".gz_new");
                InputStream inputStream = bl ? new GZIPInputStream(fileInputStream) : fileInputStream;
                Throwable throwable3 = null;
                try {
                    Pack200.Unpacker unpacker = Pack200.newUnpacker();
                    unpacker.unpack(inputStream, (JarOutputStream)object);
                }
                catch (Throwable throwable4) {
                    try {
                        Throwable throwable5 = throwable4;
                        throwable3 = throwable4;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (throwable3 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                        } else {
                            inputStream.close();
                        }
                        throw throwable6;
                    }
                }
                inputStream.close();
            }
            catch (Throwable throwable8) {
                try {
                    serializable = throwable8;
                    throwable2 = throwable8;
                    throw serializable;
                }
                catch (Throwable throwable9) {
                    if (throwable2 != null) {
                        try {
                            ((ZipOutputStream)object).close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                    } else {
                        ((ZipOutputStream)object).close();
                    }
                    throw throwable9;
                }
            }
            ((ZipOutputStream)object).close();
        }
        catch (Throwable throwable11) {
            try {
                object = throwable11;
                throwable = throwable11;
                throw object;
            }
            catch (Throwable throwable12) {
                if (throwable != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Throwable throwable13) {
                        throwable.addSuppressed(throwable13);
                    }
                } else {
                    ((InputStream)fileInputStream).close();
                }
                throw throwable12;
            }
        }
        ((InputStream)fileInputStream).close();
        return;
    }

    public static void copy(File object, File object2) throws IOException {
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            object2 = new FileOutputStream((File)object2);
            Throwable throwable2 = null;
            try {
                StreamUtil.copy((InputStream)object, object2);
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable3;
                    throwable2 = throwable3;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable2 != null) {
                        try {
                            ((FileOutputStream)object2).close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        ((FileOutputStream)object2).close();
                    }
                    throw throwable5;
                }
            }
            ((FileOutputStream)object2).close();
        }
        catch (Throwable throwable7) {
            try {
                object2 = throwable7;
                throwable = throwable7;
                throw object2;
            }
            catch (Throwable throwable8) {
                if (throwable != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                } else {
                    ((FileInputStream)object).close();
                }
                throw throwable8;
            }
        }
        ((FileInputStream)object).close();
        return;
    }

    public static void makeExecutable(File file) {
        try {
            if (file.exists() && !file.setExecutable(true, false)) {
                Log.log.warning("Failed to mark as executable", "file", file);
            }
            return;
        }
        catch (Exception exception) {
            Log.log.warning("Failed to mark as executable", "file", file, "error", exception);
            return;
        }
    }

    public static void walkTree(File object, Visitor visitor) {
        if ((object = ((File)object).listFiles()) == null) {
            return;
        }
        object = new ArrayDeque<File>(Arrays.asList(object));
        while (!object.isEmpty()) {
            File[] fileArray = (File[])object.pop();
            if (!fileArray.exists()) continue;
            visitor.visit((File)fileArray);
            if ((fileArray = fileArray.listFiles()) == null) continue;
            for (File file : fileArray) {
                object.push(file);
            }
        }
    }

    public static interface Visitor {
        public void visit(File var1);
    }
}

