/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;

public class LaunchUtil {
    public static final String LOCAL_JAVA_DIR = "java_vm";
    protected static boolean _isWindows;
    protected static boolean _isMacOS;
    protected static boolean _isLinux;

    public static boolean updateVersionAndRelaunch(File serializable, String string, String string2) throws IOException {
        Object object = new File((File)serializable, "version.txt");
        object = new PrintStream(new FileOutputStream((File)object));
        Object[] objectArray = null;
        try {
            ((PrintStream)object).println(string2);
            ((PrintStream)object).close();
        }
        catch (Throwable objectArray2) {
            try {
                serializable = objectArray2;
                objectArray = objectArray2;
                throw serializable;
            }
            catch (Throwable throwable) {
                if (objectArray != null) {
                    try {
                        ((PrintStream)object).close();
                    }
                    catch (Throwable throwable2) {
                        objectArray.addSuppressed(throwable2);
                    }
                } else {
                    ((PrintStream)object).close();
                }
                throw throwable;
            }
        }
        object = new File((File)serializable, string);
        if (LaunchUtil.mustMonitorChildren() || !((File)object).exists()) {
            return false;
        }
        objectArray = new String[]{LaunchUtil.getJVMPath((File)serializable), "-jar", ((File)object).toString(), ((File)serializable).getPath()};
        Log.log.info("Running " + StringUtil.join(objectArray, "\n  "), new Object[0]);
        try {
            Runtime.getRuntime().exec((String[])objectArray, null);
            return true;
        }
        catch (IOException iOException) {
            Log.log.warning("Failed to run getdown", iOException);
            return false;
        }
    }

    public static String getJVMPath(File file) {
        return LaunchUtil.getJVMPath(file, false);
    }

    public static String getJVMPath(File file, boolean bl) {
        String string = LaunchUtil.checkJVMPath(new File(file, LOCAL_JAVA_DIR).getAbsolutePath(), bl);
        if (string == null) {
            string = LaunchUtil.checkJVMPath(System.getProperty("java.home"), bl);
        }
        if (string == null) {
            Log.log.warning("Unable to find java [appdir=" + file + ", java.home=" + System.getProperty("java.home") + "]!", new Object[0]);
            string = "java";
        }
        if (LaunchUtil.isMacOS()) {
            try {
                file = new File("/usr/bin/java").getCanonicalFile();
                if (file.equals(new File(string).getCanonicalFile())) {
                    string = "/usr/bin/java";
                }
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to check Mac OS canonical VM path.", iOException);
            }
        }
        return string;
    }

    public static void upgradeGetdown(File file, File file2, File file3) {
        if (!file3.exists() || file3.length() == file2.length()) {
            return;
        }
        Log.log.info("Updating Getdown with " + file3 + "...", new Object[0]);
        if (file.exists()) {
            FileUtil.deleteHarder(file);
        }
        if (!file2.exists() || file2.renameTo(file)) {
            if (file3.renameTo(file2)) {
                FileUtil.deleteHarder(file);
                try {
                    FileUtil.copy(file2, file3);
                    return;
                }
                catch (IOException iOException) {
                    Log.log.warning("Error copying updated Getdown back: " + iOException, new Object[0]);
                    return;
                }
            }
            Log.log.warning("Unable to renameTo(" + file + ").", new Object[0]);
            if (!file.renameTo(file2)) {
                Log.log.warning("Oh God, why dost thee scorn me so.", new Object[0]);
            }
        }
        Log.log.info("Attempting to upgrade by copying over " + file2 + "...", new Object[0]);
        try {
            FileUtil.copy(file3, file2);
            return;
        }
        catch (IOException iOException) {
            Log.log.warning("Mayday! Brute force copy method also failed.", iOException);
            return;
        }
    }

    public static boolean mustMonitorChildren() {
        String string = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        return string.indexOf("windows 98") != -1 || string.indexOf("windows me") != -1;
    }

    public static final boolean isWindows() {
        return _isWindows;
    }

    public static final boolean isMacOS() {
        return _isMacOS;
    }

    public static final boolean isLinux() {
        return _isLinux;
    }

    protected static String checkJVMPath(String string, boolean bl) {
        String string2 = (string = string + File.separator + "bin" + File.separator) + "java";
        if (new File(string2).exists()) {
            return string2;
        }
        if (!bl && new File(string2 = string + "javaw.exe").exists()) {
            return string2;
        }
        string2 = string + "java.exe";
        if (new File(string2).exists()) {
            return string2;
        }
        return null;
    }

    static {
        try {
            String string = System.getProperty("os.name");
            string = string == null ? "" : string;
            _isWindows = string.indexOf("Windows") != -1;
            _isMacOS = string.indexOf("Mac OS") != -1 || string.indexOf("MacOS") != -1;
            _isLinux = string.indexOf("Linux") != -1;
        }
        catch (Exception exception) {}
    }
}

