remove(list=ls())           #clean up this case before starting
source("../../WAcode/mann_Rfunctions.r")
param.input<-read.control("control_WA_scenario_6a.txt")

#the following two commands will work under unix only; if under windows,
#make a folder called as the caselabel and skip them 
system(paste("rm -r",param.input$caselabel))  #delete any directory that happens to be there called as the caselabel
system(paste("mkdir",param.input$caselabel))  #make a new directory called as the caselabel

logfile<-paste(param.input$caselabel,"/logfile.",param.input$caselabel,sep="")
write("log:",file=logfile)

statsfile<-paste(param.input$caselabel,"/VerificationStatistics.",param.input$caselabel,".dat",sep="")
write("Verification Statistics:",file=statsfile)


#loop over reconstruction networks:

for(i in 1:param.input$proxy.periods){
  print(i)
  syear = param.input[[paste("years.proxy",i,sep="")]]
  write(paste("*******************************************************"),file=logfile,append=TRUE)
  write(paste("Proxy period number",i,"starting at year ",syear[1]),file=logfile,append=TRUE)
  write(paste("-------------------------------------------------------",""),file=logfile,append=TRUE)
  write(paste("*******************************************************"),file=statsfile,append=TRUE)
  write(paste("Proxy period number",i,"starting at year ",syear[1]),file=statsfile,append=TRUE)
  write(paste("-------------------------------------------------------",""),file=statsfile,append=TRUE)

  data.objects<-format.datamatrices(param.input,i)

  svdproduct<-get.svd(param.input,i,data.objects,logfile)

  proxyfit<-mann.fit(param.input,data.objects,svdproduct,logfile)

  writeout.res(param.input,data.objects,svdproduct,proxyfit,logfile)
  
}


#the following command will work under unix only, skip it if under windows...
#then zip everything in the folder called as the caselabel up if you like

system(paste("tar cvf ",param.input$caselabel,".tar ","WA_*.r ","control_*.txt ","../../WAcode/mann_Rfunctions.r ",param.input$caselabel,"/",sep=""))  #tar up everyting




