#################################################################
#
# MASTERFILE for running MBH-reconstruction. 
#
# See: Wahl and Ammann, 2006 (Climatic Change)
#      http://www.cgd.ucar.edu/ccr/ammann/millennium/mbh-reevaluation.html
#
# Versions: September, 2004 (original)
#           December, 2004  (added options for non-standard reconstructions)
#           April, 2005     (added option to turn off rPC scaling)
#           September, 2006 (Separated Statistics Output)
#           December, 2006  (Expansion of Statistics Output)
#           June, 2007      (Full Annotation)
#
#################################################################
#
# Requires 2 Files: Control file, MBH_Rfunctions file
#
# Generates : Log- and Statistics Files,
#             EOF-, PC- and SV-Files for each Reconstruction network
#             Northern-Hemisphere temperature Reconstructions for each Network
#
#################################################################
#
# This code was tested on Apple OS-X 10.4.x
# For Windows-based systems: comment-out the lines between:
#
#    ###+++UNIX_ONLY+++###
#      {comment-out these lines}
#    ###---UNIX_ONLY---###
#
#################################################################

print("*********************************")
print("WA_emulation of MBH recontruction")
print("*********************************")
print("Code Version: June, 2006         ")
print("*********************************")
print("see Wahl&Ammann, Climatic Change ")
print("and http://www.cgd.ucar.edu/ccr/ammann/millennium/mbh_reevaluation.html")
print("*********************************")

###############
#
# Prepare
#
###############

remove(list=ls())                                 #clean up this case before starting

source("MBH_Rfunctions_annotated.r")                        #load file with all R-Functions
param.input<-read.control("MBH_control.txt")
                                                  #read control-file information
###+++UNIX_ONLY+++###
#if under windows, generate a folder with name $caselabel and skip these system commands 
system(paste("rm -r",param.input$caselabel))      #remove old directory $caselabel
system(paste("mkdir",param.input$caselabel))      #make a new directory $caselabel
###---UNIX_ONLY---###

logfile<-paste(param.input$caselabel,"/logfile.",param.input$caselabel,sep="")
write("log:",file=logfile)                        #initialize and start Log-File

statsfile<-paste(param.input$caselabel,"/VerificationStatistics.",param.input$caselabel,".dat",sep="")
write("Verification Statistics:",file=statsfile)  #initialize and start Stats-File



###############
#
# Run Reconstruction separately for each Proxy-Network
#
###############

for(i in 1:param.input$num.proxy.periods){
  print(i)

  syear = param.input[[paste("years.proxy",i,sep="")]]
  write(paste("*******************************************************"),file=logfile,append=TRUE)
  write(paste("Proxy period number",i,"starting at year ",syear[1]),file=logfile,append=TRUE)
  write(paste("-------------------------------------------------------",""),file=logfile,append=TRUE)
  write(paste("*******************************************************"),file=statsfile,append=TRUE)
  write(paste("Proxy period number",i,"starting at year ",syear[1]),file=statsfile,append=TRUE)
  write(paste("-------------------------------------------------------",""),file=statsfile,append=TRUE)

  
  data.objects<-format.datamatrices(param.input,i)                #call routine for generating instrumental arrays

  svdproduct<-get.svd(param.input,i,data.objects,logfile)         #call routine for generating instrumental PCs

  proxyfit<-mann.fit(param.input,data.objects,svdproduct,logfile) #call routine for reconstruction

  writeout.res(param.input,data.objects,svdproduct,proxyfit,logfile) #write results
  
}

###############
#
# Clean-up and tar-up all files used or generated
#
###############

###+++UNIX_ONLY+++###
system(paste("tar cvf ",param.input$caselabel,".tar ","WA_*.r ","control_*.txt ","../../WAcode/MBH_Rfunctions.r ",param.input$caselabel,"/",sep=""))  
###---UNIX_ONLY---###

