load "/fs/cgd/data0/shea/nclGSUN/gsn_code.ncl"
load "/fs/cgd/data0/shea/nclGSUN/gsn_csm.ncl"
load "/fs/cgd/home0/shea/ncld/colors/genCmapHue.ncl"
load "/fs/cgd/home0/shea/ncld/colors/genCmapGray.ncl"
load "/fs/cgd/data0/shea/nclGSUN/shea_util.ncl"
load "/fs/cgd/data0/shea/nclGSUN/contributed.ncl"

begin

; ************************************************************
; Variables to set:  *****************************************
; ************************************************************
  X11=0                  ; select Output                     *
  PS=1                                                      ;*
  CASE = "WA_original"
 
; ************************************************************
; currently plots:
;
; ************************************************************
; Workstation or PS Output specifications:

    if (X11 .eq. 1) then
;          wks = gsn_open_wks("x11","gsun11n") ; Open a workstation.
          wks = gsn_open_wks("x11","line") ; Open a workstation.
    end if
    if (PS .eq. 1) then
          wks = create "gsun11n" psWorkstationClass defaultapp
           "wkPSFileName" : CASE+"/NHem.reconstruction.ps"
          end create
    end if

; ************************************************************
; Read Files:
print("Read Files...")
  m  = asciiread("../../MBHdata/MBH_1400_1980_reconstructions.txt",(/581,7/),"float")

  f1 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1400.dat",(/581/),"float")
  f2 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1450.dat",(/531/),"float")
  f3 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1500.dat",(/481/),"float")
  f4 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1600.dat",(/381/),"float")
  f5 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1700.dat",(/281/),"float")
  f6 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1730.dat",(/251/),"float")
  f7 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1750.dat",(/231/),"float")
  f8 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1760.dat",(/221/),"float")
  f9 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1780.dat",(/201/),"float")
  f10 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1800.dat",(/181/),"float")
  f11 = asciiread(CASE+"/NH.Tmat.anomaly.fitted_corrected.1820.dat",(/161/),"float")

  itime = ispan(1400,1980,1)
  NH = new((/6,581/),float)
;original MBH data
  NH(0,:)       = m(0:580,1)
  mbh_mean = avg(NH(0,502:580))

;reconstructed values WA
  NH(2,0:49)    = f1(0:49)
  NH(2,50:99)   = f2(0:49)
  NH(2,100:199) = f3(0:99)
  NH(2,200:299) = f4(0:99)
  NH(2,300:329) = f5(0:29)
  NH(2,330:349) = f6(0:19)
  NH(2,350:359) = f7(0:9)
  NH(2,360:379) = f8(0:19)
  NH(2,380:399) = f9(0:19)
  NH(2,400:419) = f10(0:19)
  NH(2,420:580) = f11(0:160)

  WA_mean = avg(NH(2,502:580))

print("Mann et al. mean of Calibration period: "+mbh_mean)
print("Wahl-Ammann mean of Calibration period: "+WA_mean)

  do i=0,580
     NH(0,i)  = NH(0,i) - mbh_mean
     NH(2,i)  = NH(2,i) - WA_mean
  end do
  
  print("MBH calib-mean : "+avg(NH(0,502:580)))
  print("WA  calib-mean : "+avg(NH(2,502:580)))
;*****************************************************************

; Contour Plot 
print("Plot : ...")

  plot                      = new(20,graphic)

  pres                      = True
;  pres@gsnMaximize          = True

  res                       = True

  res@gsnDraw               = False
  res@gsnFrame              = False
  res@vpWidthF              = 0.9
  res@vpHeightF             = 0.5

  res@xyDashPatterns       = (/0,0,0,0/)
  res@xyLineColors         = (/"Black","Black","Red","Red"/) ; line color
  res@xyLineThicknesses    = (/1,2,1,2/) ; line color

  res@tiMainString         = "N-Hemisphere Reconstructions"
  res@gsnRightString       = CASE
  res@gsnLeftString        = "annual"
  res@tiMainFontHeightF    = 0.02
  res@tmXBLabelFontHeightF = 0.02
  res@tmYLLabelFontHeightF = 0.02

;  res@pmLegendDisplayMode    = "Always"            ; Turn on drawing legend.
  res@pmLegendDisplayMode    = "Never"            ; Turn on drawing legend.
  res@pmLegendZone           = 0                   ; Change the location
  res@pmLegendOrthogonalPosF = 0.88                ; of the legend
  res@pmLegendParallelPosF   = 0.4        
  res@pmLegendSide           = "Top"
  res@pmLegendWidthF         = 0.40                ; Change width and
  res@pmLegendHeightF        = 0.20                ; height of legend.  
  res@xyExplicitLegendLabels = (/"MBH_original","","Wahl-Ammann","" /)
  res@lgPerimOn              = True 
  res@vpWidthF               = 0.99
  res@vpHeightF              = 0.4
  res@gsnYRefLine            = 0.
  res@txFontHeightF          = 0.02

;  res@trXMinF              = 1870.
  res@trYMaxF              =  0.8
  res@trYMinF              = -0.8
  
  print("smooth")
  wgt = gaus(25)
  NH(1,:) = wgt_runave(NH(0,:),wgt(:,1),0)
  NH(3,:) = wgt_runave(NH(2,:),wgt(:,1),0)

  plot(0)  = gsn_csm_xy(wks,itime,NH,res)
  plot(1)  = gsn_csm_xy(wks,itime(445:580),NH(:,445:580),res) 
  gsn_panel(wks,plot(0:1),(/2,1/),pres)
  

NHrec = new((/581,3/),float)
NHrec(:,0) = itime
NHrec(:,1) = NH(0,:)
NHrec(:,2) = NH(2,:)

opt = True
opt@fout = CASE+"/NHem.reconstruction.dat"
optform = "f5.0,2f12.6"
write_matrix(NHrec,optform,opt)

g=gaus(25)
NHrec(:,1) = wgt_runave(NH(0,:),g(:,1),0)
NHrec(:,2) = wgt_runave(NH(2,:),g(:,1),0)

opt@fout = CASE+"/NHem.reconstruction_50yrGaus.dat"
write_matrix(NHrec,optform,opt)

k=gaus(5)
NHrec(:,1) = wgt_runave(NH(0,:),k(:,1),0)
NHrec(:,2) = wgt_runave(NH(2,:),k(:,1),0)
opt@fout = CASE+"/NHem.reconstruction_10yrGaus.dat"
write_matrix(NHrec,optform,opt)

l=gaus(3)
NHrec(:,1) = wgt_runave(NH(0,:),l(:,1),0)
NHrec(:,2) = wgt_runave(NH(2,:),l(:,1),0)
opt@fout = CASE+"/NHem.reconstruction_6yrGaus.dat"
write_matrix(NHrec,optform,opt)

j=gaus(15)
NHrec(:,1) = wgt_runave(NH(0,:),j(:,1),0)
NHrec(:,2) = wgt_runave(NH(2,:),j(:,1),0)
opt@fout = CASE+"/NHem.reconstruction_30yrGaus.dat"
write_matrix(NHrec,optform,opt)
  

end
